SELECT tsystem.function__drop_by_regex( 'resource_timeline__ab2_buffer_time__fetch', 'scheduling', _commit => true ); -- Die Funktion resource_timeline__ab2_buffer_time__fetch() ist abhängig vom Typ resource_timeline__buffer.
DROP TYPE IF EXISTS scheduling.resource_timeline__buffer;
CREATE TYPE scheduling.resource_timeline__buffer AS (
  ab2_a2_id_from int,
  ab2_a2_id_to int,

  resource_id_from int,
  resource_id_to int,

  resource_timeline_ti_start_min_from timestamp,
  resource_timeline_ti_end_max_from timestamp,

  resource_timeline_ti_start_min_to timestamp,
  resource_timeline_ti_end_max_to timestamp,

  walltime_diff numeric,
  walltime_free numeric,
  workunit_free numeric,

  error_msg text
);

-- TODO IN USAGE?!
SELECT tsystem.function__drop_by_regex( 'resource_timeline__ab2_buffer_time__fetch', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.resource_timeline__ab2_buffer_time__fetch(
      _from_ab2_a2_id int,
      _to_ab2_a2_id int = null
  ) RETURNS scheduling.resource_timeline__buffer AS $$
  DECLARE

      _from_ab2_data record;
      _to_ab2_data   record;

      _result scheduling.resource_timeline__buffer;

      _timediff interval;
      _time_loop record;

      _loglevel int := TSystem.Log_Get_LogLevel( _user => 'yes' );

  BEGIN

      /*
      SELECT
          a2_id, a2_n, a2_ab_ix, ti_resource_id,
          min( ti_date_start ) ti_date_start_min,
          max( ti_date_end ) ti_date_end_max
      FROM scheduling.resource_timeline
      JOIN ab2 ON scheduling.resource_timeline.ti_a2_id = ab2.a2_id
      WHERE
            ti_a2_id =  _from_ab2_a2_id
        AND ti_type = 'task'
        AND ti_resource_id = scheduling.resource_timeline__resource_id_main_resource__get( a2_id )
      GROUP BY a2_id, ti_resource_id
      INTO _from_ab2_data;
      */

      SELECT a2_id, a2_n, a2_ab_ix,
             a2w_resource_id_main_terminated AS ti_resource_id,
             a2_at AS ti_date_start_min,
             a2_et AS ti_date_end_max
        FROM ab2 JOIN ab2_wkstplan ON a2w_a2_id = a2_id
       WHERE
             a2_id =  _from_ab2_a2_id
        INTO _from_ab2_data;

      -- fetch next ab2 if non is specified
      IF _to_ab2_a2_id IS null THEN
          _to_ab2_a2_id := (scheduling.ab2__next__terminated__get( _from_ab2_a2_id )).a2_id;
      END IF;

      /*
      SELECT
          a2_id, a2_n, a2_ab_ix, ti_resource_id,
          min( ti_date_start ) ti_date_start_min,
          max( ti_date_end ) ti_date_end_max
      FROM scheduling.resource_timeline
      JOIN ab2 ON scheduling.resource_timeline.ti_a2_id = ab2.a2_id
      WHERE
            ti_a2_id =  _to_ab2_a2_id
        AND ti_type = 'task'
      GROUP BY a2_id, ti_resource_id
      INTO _to_ab2_data;
      */
      SELECT a2_id, a2_n, a2_ab_ix,
             a2w_resource_id_main_terminated AS ti_resource_id,
             a2_at AS ti_date_start_min,
             a2_et AS ti_date_end_max
        FROM ab2 JOIN ab2_wkstplan ON a2w_a2_id = a2_id
       WHERE
             a2_id =  _to_ab2_a2_id
        INTO _to_ab2_data;

      RAISE NOTICE '[buffertime]: ab2 % ~> ab2 %', _from_ab2_data.a2_id, _to_ab2_data.a2_id;

      IF
          _from_ab2_data IS null
      THEN
          RETURN null;
      END IF;

      IF ( _to_ab2_data IS null ) THEN
          RETURN null;
      END IF;

      -- raise EXCEPTION '%', _from_ab2_data;

      -- from data
      _result.ab2_a2_id_from := _from_ab2_data.a2_id;
      _result.resource_id_from := _from_ab2_data.ti_resource_id;
      _result.resource_timeline_ti_start_min_from := _from_ab2_data.ti_date_start_min;
      _result.resource_timeline_ti_end_max_from := _from_ab2_data.ti_date_end_max;

      -- to data
      _result.ab2_a2_id_to := _to_ab2_data.a2_id;
      _result.resource_id_to := _to_ab2_data.ti_resource_id;
      _result.resource_timeline_ti_start_min_to := _to_ab2_data.ti_date_start_min;
      _result.resource_timeline_ti_end_max_to := _to_ab2_data.ti_date_end_max;

      -- forward case
      IF ( _from_ab2_data.a2_n < _to_ab2_data.a2_n ) THEN

          -- Zeitfenster für Suche nach Puffer ergibt sich aus ( Beginn Folge AG - Anfang AG ) - Transportzeit.
          -- _timediff :=
          --       _to_ab2_data.ti_date_start_min
          --     - scheduling.resource__transport_time__get(
          --               _from_ab2_data.ti_date_end_max,
          --               _from_ab2_data.ti_resource_id,
          --               _to_ab2_data.ti_resource_id,
          --               _loglevel => _loglevel
          --        );

          -- Zeitfesnter für Suche nach Puffer ergibt sich aus Beginn Folge AG - Anfang AG.
          _timediff := _to_ab2_data.ti_date_start_min -_from_ab2_data.ti_date_end_max;

      ELSE

          raise exception 'the backward way makes no sense!';

          -- _timediff :=
          --       _from_ab2_data.ti_date_start_min
          --     - scheduling.resource__transport_time__get(
          --               _to_ab2_data.ti_date_end_max,
          --               _to_ab2_data.ti_resource_id,
          --               _to_ab2_data.ti_resource_id,
          --               1,
          --               _loglevel => _loglevel
          --        )
          -- ;

      END IF;

      -- Anfang / Ende ist gleich oder kleiner. Somit gibt es keinen Slot und wir brauchen nicht zu suchen
      IF _timediff <= '0:15'::interval THEN
         _result.walltime_diff := 0;
         _result.walltime_free := 0;
         _result.workunit_free := 0;
         RETURN _result;
      END IF;

      _result.walltime_diff := extract( epoch FROM _timediff );

      -- add up free timeslots

      _result.workunit_free := 0;
      _result.walltime_free := 0;

      BEGIN

          FOR _time_loop IN

              SELECT
                date_end AS date_from,
                next_start AS date_to
              FROM scheduling.resource_timeline__select(
                 _resource_id     => _from_ab2_data.ti_resource_id,
                 _target_load     => 1,
                 _timeframe_start => _from_ab2_data.ti_date_end_max,
                 _timeframe_end   => _from_ab2_data.ti_date_end_max + _timediff,
                 _loglevel        => _loglevel
              )
              WHERE
                    date_end IS NOT null
                AND next_start IS NOt null

          LOOP

              _result.walltime_free :=
                    _result.walltime_free
                  + date_part( 'epoch' , _time_loop.date_to - _time_loop.date_from );

              _result.workunit_free :=
                    _result.workunit_free
                  + date_part( 'epoch' , _time_loop.date_to - _time_loop.date_from )
                  * (
                      SELECT ta_kf
                      FROM scheduling.resource_timeline__timeslots_ta_kf__calc(
                          _time_loop.date_from,
                          _time_loop.date_to,
                          _from_ab2_data.ti_resource_id
                      )
                  )
              ;

          END LOOP;
      EXCEPTION

          WHEN others THEN
          BEGIN
              RAISE WARNING E'ERROR: a2_id=% \n %', _from_ab2_data, sqlerrm;
              _result.error_msg := Format( E'ERROR: a2_id=%s \n %s', _from_ab2_data, sqlerrm);
          END;

      END;

      RETURN _result;

  END $$ LANGUAGE plpgsql STABLE PARALLEL SAFE;
